/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.renderer;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.client.model.ModelMusicPlayer;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.StringUtils;

public class MusicPlayerRenderer
implements BlockEntityRenderer<TileEntityMusicPlayer> {
    public static ModelMusicPlayer<?> MODEL;
    public static final ResourceLocation TEXTURE;
    public static MusicPlayerRenderer instance;
    private final Font font;
    private final BlockEntityRenderDispatcher dispatcher;

    public MusicPlayerRenderer(BlockEntityRendererProvider.Context context) {
        MODEL = new ModelMusicPlayer(context.bakeLayer(ModelMusicPlayer.LAYER));
        instance = this;
        this.font = context.getFont();
        this.dispatcher = context.getBlockEntityRenderDispatcher();
    }

    public void render(TileEntityMusicPlayer te, float pPartialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction facing = (Direction)te.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        ItemStack cd = te.getPlayerInv().getStackInSlot(0);
        ModelPart disc = MODEL.getDiscBone();
        boolean bl = disc.visible = !cd.isEmpty();
        if (!cd.isEmpty() && te.isPlay()) {
            disc.yRot = (float)(0.15707963267948966 * ((double)System.currentTimeMillis() / 50.0 % 40.0));
        }
        this.renderMusicPlayer(matrixStack, buffer, combinedLight, facing);
        this.renderLyric(te, matrixStack, buffer, combinedLight);
    }

    public void renderMusicPlayer(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, Direction facing) {
        matrixStack.pushPose();
        matrixStack.scale(0.75f, 0.75f, 0.75f);
        matrixStack.translate(0.6666666666666666, 1.5, 0.6666666666666666);
        switch (facing) {
            case SOUTH: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
        }
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        VertexConsumer vertexBuilder = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
        MODEL.renderToBuffer(matrixStack, vertexBuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
    }

    private void renderLyric(TileEntityMusicPlayer te, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (!((Boolean)GeneralConfig.ENABLE_PLAYER_LYRICS.get()).booleanValue()) {
            return;
        }
        LyricRecord lyricRecord = te.lyricRecord;
        if (lyricRecord == null) {
            return;
        }
        Int2ObjectSortedMap<String> lyrics = lyricRecord.getLyrics();
        if (lyrics == null || lyrics.isEmpty()) {
            return;
        }
        if (!te.isPlay()) {
            te.lyricRecord = null;
            return;
        }
        Camera camera = this.dispatcher.camera;
        ChatFormatting currentLyricColor = ChatFormatting.GRAY;
        ChatFormatting transLyricColor = ChatFormatting.WHITE;
        float y = 0.5f;
        String lyric = (String)lyrics.get(lyrics.firstIntKey());
        MutableComponent currentLine = StringUtils.isNotBlank((CharSequence)lyric) ? Component.literal((String)lyric) : Component.empty();
        MutableComponent translatedLine = null;
        Int2ObjectSortedMap<String> transLyrics = lyricRecord.getTransLyrics();
        if (transLyrics != null && !transLyrics.isEmpty()) {
            String transLyric = (String)transLyrics.get(transLyrics.firstIntKey());
            if (StringUtils.isNotBlank((CharSequence)transLyric)) {
                translatedLine = Component.literal((String)transLyric);
            }
            y += 0.5f;
        } else {
            currentLyricColor = ChatFormatting.WHITE;
        }
        currentLine = currentLine.withStyle(currentLyricColor);
        poseStack.pushPose();
        poseStack.translate(0.5, 1.625, 0.5);
        poseStack.mulPose(Axis.YN.rotationDegrees(camera.getYRot()));
        poseStack.mulPose(Axis.XN.rotationDegrees(-camera.getXRot()));
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        float opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int bgColor = (int)(opacity * 255.0f) << 24;
        if (!currentLine.getContents().equals((Object)PlainTextContents.EMPTY)) {
            float currentLineWidth = -this.font.width((FormattedText)currentLine) / 2;
            this.font.drawInBatch((Component)currentLine, currentLineWidth, -y, -1, false, poseStack.last().pose(), bufferIn, Font.DisplayMode.NORMAL, bgColor, combinedLightIn);
        }
        if (translatedLine != null) {
            float translatedLineWidth = -this.font.width((FormattedText)translatedLine) / 2;
            translatedLine = translatedLine.withStyle(transLyricColor);
            this.font.drawInBatch((Component)translatedLine, translatedLineWidth, -y - 12.0f, -1, false, poseStack.last().pose(), bufferIn, Font.DisplayMode.NORMAL, bgColor, combinedLightIn);
        }
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(TileEntityMusicPlayer musicPlayer) {
        return true;
    }

    public AABB getRenderBoundingBox(TileEntityMusicPlayer blockEntity) {
        BlockPos worldPosition = blockEntity.getBlockPos();
        return MusicPlayerRenderer.getAABB(worldPosition.offset(-1, 0, -1), worldPosition.offset(1, 2, 1));
    }

    public static AABB getAABB(BlockPos pStart, BlockPos pEnd) {
        return new AABB((double)pStart.getX(), (double)pStart.getY(), (double)pStart.getZ(), (double)pEnd.getX(), (double)pEnd.getY(), (double)pEnd.getZ());
    }

    static {
        TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"textures/block/music_player.png");
    }
}

